/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.fsp.cmdhelpers;

import com.ibm.hsc.common.exceptions.PIHscCmdMgrException;
import com.ibm.hsc.common.exceptions.PIHscServerException;
import com.ibm.hsc.fsp.FSPCmdMgr;
import java.util.Hashtable;
import java.util.Vector;
import org.snia.wbem.cim.UnsignedInt16;
import org.snia.wbem.cim.UnsignedInt32;

public class FspIoBus {
    private UnsignedInt16 mBusId;
    private UnsignedInt16 mNumberOfSlots;
    private String mLocationCode;
    private UnsignedInt32 mDrcIndex;
    private String mDrcName;
    private static final String GET_IO_BUS_INFO = "GET_IO_BUS_INFO";
    private static final String NUM_SLOTS = "NUM_SLOTS";
    private static final String LOCATION_CODE = "LOCATION_CODE";
    private static final String DRC_NDX = "DRC_NDX";
    private static final String DRC_NAME = "DRC_NAME";
    private static final String GET_ALL_IO_BUS_INFO = "GET_ALL_IO_BUS_INFO";
    private static final String CUR_BUS_NUM = "CUR_BUS_NUM";
    private static final String REMAIN_BUS_NUM = "REMAIN_BUS_NUM";
    private static final String BUS_ID_LIST = "BUS_ID_LIST";
    private static final String IO_BUS_ID = "IO_BUS_ID";

    FspIoBus() {
    }

    static UnsignedInt16[] getAllIoBusIds(FSPCmdMgr fSPCmdMgr) throws PIHscServerException, PIHscCmdMgrException {
        UnsignedInt16[] unsignedInt16Array;
        Vector vector = new Vector();
        int n = 0;
        while (true) {
            int n2;
            unsignedInt16Array = fSPCmdMgr.doPhypCommand(GET_ALL_IO_BUS_INFO, new String[]{"65535", "" + n});
            int n3 = ((UnsignedInt16)unsignedInt16Array.get(CUR_BUS_NUM)).intValue();
            Object[] objectArray = (Object[])unsignedInt16Array.get(BUS_ID_LIST);
            for (n2 = 0; n2 < n3; ++n2) {
                Hashtable hashtable = (Hashtable)objectArray[n2];
                vector.addElement(hashtable.get(IO_BUS_ID));
            }
            n2 = ((UnsignedInt16)unsignedInt16Array.get(REMAIN_BUS_NUM)).intValue();
            if (n2 == 0) break;
            n += n3;
        }
        unsignedInt16Array = new UnsignedInt16[vector.size()];
        return vector.toArray(unsignedInt16Array);
    }

    FspIoBus getIoBusInfoCmd(FSPCmdMgr fSPCmdMgr, UnsignedInt16 unsignedInt16) throws PIHscServerException, PIHscCmdMgrException {
        Hashtable hashtable = null;
        try {
            hashtable = fSPCmdMgr.doPhypCommand(GET_IO_BUS_INFO, new String[]{unsignedInt16.toString()});
            this.mBusId = unsignedInt16;
            this.mNumberOfSlots = (UnsignedInt16)hashtable.get(NUM_SLOTS);
            this.mLocationCode = ((String)hashtable.get(LOCATION_CODE)).trim();
            this.mDrcIndex = (UnsignedInt32)hashtable.get(DRC_NDX);
            this.mDrcName = ((String)hashtable.get(DRC_NAME)).trim();
            return this;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return null;
        }
    }

    public UnsignedInt16 getBusId() {
        return this.mBusId;
    }

    public UnsignedInt16 getNumberOfSlots() {
        return this.mNumberOfSlots;
    }

    public String getLocationCode() {
        return this.mLocationCode;
    }

    public UnsignedInt32 getDrcIndex() {
        return this.mDrcIndex;
    }

    public String getDrcName() {
        return this.mDrcName;
    }
}

